unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileCtrl, MMPCXCtl, MMPCX, MMCCon, MMObj, MMHook, MMDesign, MMDIBCv, MMLevel,
  StdCtrls, MMWheel, MMPCXTol, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label5: TLabel;
    Label22: TLabel;
    Volume: TMMWheel;
    FilePanel1: TPanel;
    FName1: TLabel;
    btnFile1: TButton;
    btnPlay1: TButton;
    Panel2: TPanel;
    Label11: TLabel;
    Label18: TLabel;
    Volume2: TMMWheel;
    FilePanel2: TPanel;
    FName2: TLabel;
    btnFile2: TButton;
    btnPlay2: TButton;
    Panel3: TPanel;
    Label15: TLabel;
    Label10: TLabel;
    Volume3: TMMWheel;
    FilePanel3: TPanel;
    FName3: TLabel;
    btnFile3: TButton;
    btnPlay3: TButton;
    Panel4: TPanel;
    Label19: TLabel;
    Label4: TLabel;
    Volume4: TMMWheel;
    FilePanel4: TPanel;
    FName4: TLabel;
    btnFile4: TButton;
    btnPlay4: TButton;
    btnStop: TButton;
    btnStart: TButton;
    Level1: TMMLevel;
    Level2: TMMLevel;
    MMDesigner1: TMMDesigner;
    PCXConnector: TMMPCXConnector;
    PCXPipe: TMMPCXPipe;
    OutputStream1: TMMPCXOutputStream;
    PCXCard: TMMPCXCard;
    OutputStream2: TMMPCXOutputStream;
    OutputStream3: TMMPCXOutputStream;
    OutputStream4: TMMPCXOutputStream;
    lblPos1: TMMPCXStreamTimeLabel;
    lblPos2: TMMPCXStreamTimeLabel;
    lblPos3: TMMPCXStreamTimeLabel;
    lblPos4: TMMPCXStreamTimeLabel;
    OpenDialog: TOpenDialog;
    MMPCXPipeTimeLabel1: TMMPCXPipeTimeLabel;
    Label1: TLabel;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    btnStop1: TButton;
    btnStop2: TButton;
    btnStop3: TButton;
    btnStop4: TButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure btnStop1Click(Sender: TObject);
  private
    procedure UpdateFileLabel(Tag: integer);
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   { allocate the Pipe }
   PCXPipe.Allocate;
   Label2.Caption:= PCXPipe.BoardName;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   btnStopClick(nil);
   { release the Pipe }
   PCXpipe.Release;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
begin
   PCXPipe.Start;
   btnStart.Enabled := False;
   btnStop.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   PCXPipe.Stop;
   btnStart.Enabled := True;
   btnStop.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.UpdateFileLabel(Tag: integer);
begin
   case Tag of
      0: FName1.Caption := MinimizeName(OutputStream1.FileName,FName1.Canvas,FName1.Width);
      1: FName2.Caption := MinimizeName(OutputStream2.FileName,FName2.Canvas,FName2.Width);
      2: FName3.Caption := MinimizeName(OutputStream3.FileName,FName3.Canvas,FName3.Width);
      3: FName4.Caption := MinimizeName(OutputStream4.FileName,FName4.Canvas,FName4.Width);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      case TControl(Sender).Tag of
         0: begin
               { set the new filename }
               OutputStream1.FileName := OpenDialog.FileName;
            end;
         1: begin
               OutputStream2.FileName := OpenDialog.FileName;
            end;
         2: begin
               OutputStream3.FileName := OpenDialog.FileName;
            end;
         3: begin
               OutputStream4.FileName := OpenDialog.FileName;
            end;
      end;
      UpdateFileLabel(TControl(Sender).Tag);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
             OutputStream1.Prepare(0,PLAY_ALL_FILE);
             OutputStream1.Play;
          end;
       1: begin
             OutputStream2.Prepare(0,PLAY_ALL_FILE);
             OutputStream2.Play;
          end;
       2: begin
             OutputStream3.Prepare(0,PLAY_ALL_FILE);
             OutputStream3.Play;
          end;
       3: begin
             OutputStream4.Prepare(0,PLAY_ALL_FILE);
             OutputStream4.Play;
          end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStop1Click(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
             OutputStream1.Stop;
          end;
       1: begin
             OutputStream2.Stop;
          end;
       2: begin
             OutputStream3.Stop;
          end;
       3: begin
             OutputStream4.Stop;
          end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.VolumeMasterChange(Sender: TObject);
var
   Val: Float;
begin
   Val := VolumeMaster.Value/100;
   PCXPipe.SetLevel(ltDigital, Val,Val);
end;

{------------------------------------------------------------------------------}
procedure TForm1.VolumeChange(Sender: TObject);
var
   Val: Float;
begin
   Val := TMMWheel(Sender).Value/100;
   case TControl(Sender).Tag of
       0: begin
             OutputStream1.SetLevel(Val);
          end;
       1: begin
             OutputStream2.SetLevel(Val);
          end;
       2: begin
             OutputStream3.SetLevel(Val);
          end;
       3: begin
             OutputStream4.SetLevel(Val);
          end;
   end;
end;

end.
